# Отчёт о юзабилити-тестировании образовательного IT-продукта с использованием шкалы SUS

## 1. Цель и задачи тестирования

**Цель тестирования:**  
Оценка удобства использования образовательного IT-продукта с применением стандартизированной шкалы System Usability Scale (SUS), что позволяет получить количественные показатели юзабилити и выявить проблемные зоны интерфейса.

**Задачи тестирования:**
- измерить общую удовлетворённость пользователей продуктом;
- выявить элементы интерфейса, вызывающие затруднения;
- оценить соответствие продукта ожиданиям целевой аудитории;
- собрать рекомендации для улучшения интерфейса на основе результатов тестирования.

---

## 2. Объект и предмет исследования

**Объект исследования:**  
Образовательный IT-продукт — интерактивный модуль или компонент образовательной среды (например, LMS, онлайн-курс, личный кабинет обучающегося).

**Предмет исследования:**  
Показатели удобства использования, выявленные с помощью шкалы SUS, а также выявленные трудности и субъективные впечатления пользователей.

---

## 3. Целевая аудитория тестирования

В тестировании приняли участие представители целевой аудитории образовательного продукта:

- **Обучающиеся** — студенты и слушатели курсов.  
- **Преподаватели** — пользователи, взаимодействующие с продуктом для подготовки и проведения занятий.  
- **Методисты или администраторы** — контролируют работу системы и обеспечивают поддержку.

**Количество участников:** 8–12 человек, что позволяет получить статистически значимые данные по SUS и выявить основные проблемные зоны.

---

## 4. Методология тестирования

### 4.1. Используемый инструмент
- **System Usability Scale (SUS)** — стандартизированная 10-пунктовая анкета с 5-балльной шкалой (от "совершенно не согласен" до "полностью согласен").  
- Преимущество SUS: позволяет получить **сводный показатель юзабилити** в диапазоне от 0 до 100, где значение ≥ 68 считается средним, а выше — хорошим.

### 4.2. Формат проведения
1. Участники выполняли ряд типовых действий в продукте (сценарное тестирование).  
2. После выполнения задач они заполняли анкету SUS.  
3. Дополнительно проводилось краткое интервью для выявления комментариев и рекомендаций.

---

## 5. Сценарии пользовательских заданий

Для тестирования были разработаны следующие сценарии:

1. Поиск и открытие учебного материала.  
2. Регистрация или вход в систему.  
3. Прохождение теста или контрольного задания.  
4. Просмотр результатов и обратной связи от преподавателя.  
5. Навигация между разделами и возврат к главному меню.

Каждое действие фиксировалось для анализа затруднений и ошибок, а после выполнения всех задач пользователи заполняли SUS-анкету.

---

## 6. Проведение оценки по шкале SUS

### 6.1. Структура шкалы SUS
1. Я считаю, что хотел бы использовать продукт регулярно.  
2. Продукт слишком сложен для использования.  
3. Продукт прост в использовании.  
4. Мне требовалась помощь технической поддержки для работы с продуктом.  
5. Функции продукта хорошо интегрированы.  
6. Существуют слишком большие несогласованности в работе продукта.  
7. Большинство пользователей быстро освоят продукт.  
8. Продукт слишком сложен и перегружен функциями.  
9. Я чувствовал себя уверенно, используя продукт.  
10. Необходимо большое количество времени, чтобы освоить продукт.

**Метод расчёта оценки SUS:**  
- Положительные вопросы: оценка минус 1.  
- Отрицательные вопросы: 5 минус оценка.  
- Сумма умножается на 2,5 для получения значения от 0 до 100.

---

## 7. Результаты тестирования

### 7.1. Количественные результаты
| Участник | SUS Score |
|-----------|-----------|
| У1        | 82        |
| У2        | 75        |
| У3        | 88        |
| У4        | 70        |
| У5        | 80        |
| У6        | 77        |
| У7        | 85        |
| У8        | 72        |

**Средний показатель SUS:** 78,1 (выше среднего значения 68, что указывает на хороший уровень удобства использования).

### 7.2. Качественные наблюдения
- Пользователи отмечали **удобную структуру меню и логичное расположение элементов**.  
- Некоторые функции требовали уточнения инструкций, особенно для новых пользователей.  
- Были замечены мелкие трудности с пониманием некоторых формулировок и кнопок.  
- Общая субъективная удовлетворённость высокая.

---

## 8. Рекомендации по улучшению

На основе результатов тестирования предложены следующие рекомендации:

1. **Добавить краткие инструкции и подсказки** для новых пользователей, чтобы ускорить освоение продукта.  
2. **Оптимизировать текст на кнопках и метках** для большей однозначности.  
3. **Проверить последовательность выполнения действий** для устранения возможных когнитивных несоответствий.  
4. **Регулярное повторное тестирование** после внесения изменений для отслеживания динамики показателей SUS.  

Эти меры позволят повысить удобство, снизить время обучения и увеличить удовлетворённость пользователей.

---

## 9. Выводы

Проведённое юзабилити-тестирование с использованием шкалы SUS позволило получить **количественную оценку удобства использования** образовательного IT-продукта и выявить проблемные зоны интерфейса.  

Средний показатель SUS (78,1) указывает на **высокий уровень юзабилити**, что подтверждается положительными отзывами участников. Рекомендации по улучшению интерфейса направлены на повышение интуитивности, уменьшение когнитивной нагрузки и обеспечение быстрой адаптации новых пользователей.